/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2540;
import net.minecraft.class_2585;

public class EnumArgumentType<T extends Enum<T>>
implements ArgumentType<Enum<T>> {
    private final DynamicCommandExceptionType noValueException;
    private final String noElementMessage;
    private final Class<T> enumClass;

    private EnumArgumentType(Class<T> enumClass, String noElementMessage) {
        this.enumClass = enumClass;
        this.noElementMessage = noElementMessage;
        this.noValueException = new DynamicCommandExceptionType(o -> new class_2585(this.noElementMessage.replace("{}", o.toString())));
    }

    public static <T extends Enum<T>> EnumArgumentType<T> create(Class<T> enumClass) {
        EnumArgumentType<T> type = new EnumArgumentType<T>(enumClass, "Invalid enum value '{}'");
        class_2316.method_10017((String)("owo:enum_" + enumClass.getName().toLowerCase(Locale.ROOT)), type.getClass(), new Serializer(type));
        return type;
    }

    public static <T extends Enum<T>> EnumArgumentType<T> create(Class<T> enumClass, String noElementMessage) {
        EnumArgumentType<T> type = new EnumArgumentType<T>(enumClass, noElementMessage);
        class_2316.method_10017((String)("owo:enum_" + enumClass.getName().toLowerCase(Locale.ROOT)), type.getClass(), new Serializer(type));
        return type;
    }

    public T get(CommandContext<?> context, String name) {
        return (T)((Enum)context.getArgument(name, this.enumClass));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::toString), (SuggestionsBuilder)builder);
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readString();
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException e) {
            throw this.noValueException.create((Object)name);
        }
    }

    public static final class Serializer<T extends Enum<T>, TypeInstance extends EnumArgumentType<T>>
    implements class_2314<TypeInstance> {
        private final TypeInstance instance;

        public Serializer(TypeInstance instance) {
            this.instance = instance;
        }

        public void toPacket(TypeInstance type, class_2540 buf) {
        }

        public TypeInstance fromPacket(class_2540 buf) {
            return this.instance;
        }

        public void toJson(TypeInstance type, JsonObject json) {
        }
    }
}

